// Fire Ball by WyldAnimal
// Adapted from 
// https://www.shadertoy.com/view/lsf3RH
//

// Totem uses a different set of variables
uniform float u_Elapsed; // Replace all iGlobalTime with u_Elapsed
uniform vec2 u_WindowSize; // Replace all iResolution with u_WindowSize
uniform sampler2D texture0; // Replace all iChannel0 with Texture0 


#define rr 		2.0 		// red strength
#define rf 		0.4 		// red fall out
#define	gg		1.7			// green strength
#define	gf		0.35 		// green fall out
#define bb		2.1			// blue strength
#define bf		0.10		// blue fall out


#define fbsc	3.8			// size of fireball center
#define fbos	3.0 		// fire ball overall size - Smaller = bigger

//good fire ball settings
//#define rr 		2.0 		// red strength
//#define rf 		0.4 		// red fall out
//#define gg		1.7			// green strength
//#define gf		0.35 		// green fall out
//#define bb		2.1			// blue strength
//#define bf		0.10		// blue fall out

#define bg 0.0

float snoise(vec3 uv, float res)
{
	const vec3 s = vec3(1e0, 1e2, 1e3);
	
	uv *= res;
	
	vec3 uv0 = floor(mod(uv, res))*s;
	vec3 uv1 = floor(mod(uv+vec3(1.), res))*s;
	
	vec3 f = fract(uv); f = f*f*(3.0-2.0*f);

	vec4 v = vec4(uv0.x+uv0.y+uv0.z, uv1.x+uv0.y+uv0.z,
		      	  uv0.x+uv1.y+uv0.z, uv1.x+uv1.y+uv0.z);

	vec4 r = fract(sin(v*1e-1)*1e3);
	float r0 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
	
	r = fract(sin((v + uv1.z - uv0.z)*1e-1)*1e3);
	float r1 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
	
	return mix(r0, r1, f.z)*2.-1.;
}

void main(void) 
{
	vec2 p = -.5 + gl_FragCoord.xy / u_WindowSize.xy;
	p.x *= u_WindowSize.x/u_WindowSize.y;
	
	float color = fbsc - (fbos*length(2.*p));
	
	vec3 coord = vec3(atan(p.x,p.y)/6.2832+.5, length(p)*.4, .5);
	
	for(int i = 1; i <= 7; i++)
	{
		float power = pow(2.0, float(i));
		color += (1.5 / power) * snoise(coord + vec3(0.,-u_Elapsed*.05, u_Elapsed*.01), power*16.);
	}
	//gl_FragColor = vec4( color, pow(max(color,0.),2.)*0.4, pow(max(color,0.),3.)*0.15 , 1.0);
	gl_FragColor = vec4( pow(max(color,bg),rr)*rf, pow(max(color,bg),gg)*gf, pow(max(color,bg),bb)*bf , 1.0);
}