//
// Fragment Shader by WyldAnimal
// www.deskbabes.net
//

uniform float u_Elapsed; // same than iGlobalTime
uniform vec2 u_WindowSize; // same than iResolution 
uniform sampler2D texture; // same than iChannel0 


void main( void ) {

     vec2 position = (gl_FragCoord.xy/u_WindowSize.xy);

     float cX = position.x - 0.5;
     float cY = position.y - 0.5;

     float newX = log(sqrt(cX*cX + cY*cY));
     float newY = atan(cX, cY);
     
     float color = 0.0;
     color += cos( newX * cos(u_Elapsed / 15.0 ) * 80.0 ) + cos( newX * cos(u_Elapsed / 15.0 ) * 10.0 );
     color += cos( newY * cos(u_Elapsed / 10.0 ) * 40.0 ) + cos( newY * sin(u_Elapsed / 25.0 ) * 40.0 );
     color += cos( newX * cos(u_Elapsed / 5.0 ) * 10.0 ) + cos( newY * sin(u_Elapsed / 35.0 ) * 80.0 );
     color *= cos(u_Elapsed / 10.0 ) * 0.5;

     gl_FragColor = vec4( vec3( color, color * 0.5, sin( color + u_Elapsed / 3.0 ) * 0.75 ), 1.0 );

}